﻿/*  Author:     Ben Hall
 *  File:       Item.cs
 *  Date:       4/28/2011
 *  
 *  Purpose:    Item.cs extends the BaseItem class and is used to represent items that are usable
 *              in combat (some of which are also usable out of combat).  These Items can have effects
 *              including dealing damage, healing, or inflicting or removing status effects.
 *              
 *              The class only contains a constructor and get and set methods.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace OnlineGame
{
    public class Item : BaseItem
    {
        private bool magical;

        private bool damaging;
        private bool healing;
        private int numValue;

        private bool isBeneficial;

        private int poisonEffect;
        private float pDefenseChange;
        private float mDefenseChange;

        private bool usableOutOfCombat;

        public Item(String nameIn, int itemValueIn, bool isMagicalIn, bool damagingIn, bool healingIn, int numValueIn, bool beneficialIn, bool isUsableOutOfCombatIn, int poisonEffectIn, float pDefenseModifierIn, float mDefenseModifierIn)
        {
            this.itemName = nameIn;
            this.itemValue = itemValueIn;
            this.damaging = damagingIn;
            this.magical = isMagicalIn;
            this.healing = healingIn;
            this.numValue = numValueIn;
            this.isBeneficial = beneficialIn;

            this.poisonEffect = poisonEffectIn;
            this.pDefenseChange = pDefenseModifierIn;
            this.mDefenseChange = mDefenseModifierIn;
            
            this.usableOutOfCombat = isUsableOutOfCombatIn;
        }

        public bool IsMagic()
        {
            return this.magical;
        }

        public bool IsDamaging()
        {
            return this.damaging;
        }

        public bool IsHealing()
        {
            return this.healing;
        }

        public int GetNumValue()
        {
            return this.numValue;
        }

        public bool IsBeneficial()
        {
            return this.isBeneficial;
        }

        public int GetPoisonEffect()
        {
            return this.poisonEffect;
        }

        public float GetPDefenseChange()
        {
            return this.pDefenseChange;
        }

        public float GetMDefenseChange()
        {
            return this.mDefenseChange;
        }

        public bool IsUsableOutOfCombat()
        {
            return this.usableOutOfCombat;
        }
    }
}
